﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <cmath>
#include <iomanip>
#include <string>
#include <queue>
#include <deque>
#include <random>

using namespace std;
typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;
void fastio() { ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0); }
#define all(a) a.begin(), a.end()
#define fout(a) cout << fixed << setprecision(a)

const long long INF = 2e9;
const ll MOD = 1e9 + 7;
const ld EPS = 1e-9;
mt19937_64 rng(time(0));

ll sign(ll a) {
	if (a == 0) return 0;
	if (a > 0) return 1;
	return -1;
}

struct Point {
	ll x, y;
	Point(ll x, ll y) : x(x), y(y) {}
	Point() : x(0), y(0) {}
	void input() { 
		//x = rng() % 1000, y = rng() % 1000;
		cin >> x >> y;
	}
	bool operator==(const Point& a) const {
		return x == a.x && y == a.y;
	}
	Point operator-(const Point& a) const {
		return Point(x - a.x, y - a.y);
	}
	ll operator%(const Point& a) const {
		return x * a.y - y * a.x;
	}
	ll operator*(const Point& a) const {
		return x * a.x + y * a.y;
	}
};

bool isOnSegment(Point a, Point b, Point c) {
	return (a == c || b == c || ((a - c) % (b - c) == 0 && (a - c) * (b - c) < 0));
}

bool isper(Point a, Point b, Point c, Point d) {
	if (sign((c - a) % (b - a)) * sign((d - a) % (b - a)) < 0 &&
		sign((a - c) % (d - c)) * sign((b - c) % (d - c)) < 0
		) {
		return 1;
	}
	return (isOnSegment(a, b, c) || isOnSegment(a, b, d) || isOnSegment(c, d, a) || isOnSegment(c, d, b));
}

ll dfs(ll v, vector<vector<ll>>& g, vector<bool>& used) {
	ll sm = 1;
	used[v] = 1;
	for (ll u : g[v]) {
		if (!used[u]) {
			sm += dfs(u, g, used);
		}
	}
	return sm;
}

int main() {
	fastio();
	//cout << sin(acos(-1) / 2) << "\n";
	//cout << sin(0) << "\n";
	//fout(11) << cos(acos(-1) / 2) << "\n";
	//cout << isOnSegment(Point(1, 1), Point(4, 4), Point(2, 2)) << "\n";
	ll t;
	cin >> t;
	while (t--) {
		ll n;
		cin >> n;
		vector<pair<Point, Point>> a(n);
		for (ll i = 0; i < n; i++) {
			a[i].first.input();
			a[i].second.input();
		}
		vector<ll> k(n, 0);
		vector<vector<ll>> g(n);
		for (ll i = 0; i < n; i++) {
			for (ll j = 0; j < n; j++) {
				if (i == j) continue;
				if (isper(a[i].first, a[i].second, a[j].first, a[j].second)) {
					k[i]++;
					g[i].push_back(j);
				}
			}
		}
		ll komp = 0;
		vector<bool> used(n, 0);
		for (ll i = 0; i < n; i++) {
			if (!used[i]) {
				komp += dfs(i, g, used) > 1;
			}
		}
		ll v = 0, e = 0;
		for (ll i = 0; i < n; i++) {
			v += k[i];
			e += max(0LL, k[i] - 1);
		}
		if (v % 2 != 0) exit(-1);
		cout << komp + 1 + e - v / 2 << "\n";
	}
	return 0;
}